<?php

namespace Qoxag\Core\Elementor\Traits;

defined('ABSPATH') || exit;

trait Slider_Controls
{

    /*
    *   Slider Controls
    */
    protected function slider_controls($params = [])
    {
        $default = !empty($params) && !empty($params['defaults']) ? $params['defaults'] : [];
        $exclude = !empty($params) && !empty($params['exclude']) ? $params['exclude'] : [];

        $this->start_controls_section(
            'slider_section',
            [
                'label' => esc_html__('Slider Controls', 'qoxag'),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
            'slide_loop',
            [
                'label' => esc_html__('Loop', 'qoxag'),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => esc_html__('Yes', 'qoxag'),
                'label_off' => esc_html__('No', 'qoxag'),
                'default' => (isset($default['slide_loop']) ? esc_attr($default['slide_loop']) : ''),
                'return_value' => 'yes',
            ]
        );

        $this->add_control(
            'slide_autoplay',
            [
                'label' => esc_html__('Autoplay', 'qoxag'),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => esc_html__('Yes', 'qoxag'),
                'label_off' => esc_html__('No', 'qoxag'),
                'default' => (isset($default['slide_autoplay']) ? esc_attr($default['slide_autoplay']) : ''),
                'return_value' => 'yes',
            ]
        );

        $this->add_control(
            'slide_autoplay_delay',
            [
                'label' => esc_html__('Slide Speed', 'qoxag'),
                'type' => \Elementor\Controls_Manager::NUMBER,
                'default' => 3000,
                'min' => 0,
                'max' => 10000,
                'condition' => [
                    'slide_autoplay' => 'yes'
                ]
            ]
        );

        $this->add_control(
            'slide_arrows',
            [
                'label' => esc_html__('Show Arrows', 'qoxag'),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_off' => esc_html__('Hide', 'qoxag'),
                'label_on' => esc_html__('Show', 'qoxag'),
                'default' => (isset($default['slide_arrows']) ? esc_attr($default['slide_arrows']) : 'yes'),
                'return_value' => 'yes',
            ]
        );

        $this->add_control(
            'slide_arrow_icon_left',
            [
                'label' => esc_html__('Left Arrow', 'qoxag'),
                'type' => \Elementor\Controls_Manager::ICONS,
                'condition' => [
                    'slide_arrows' => 'yes'
                ],
                'default' => [
                    'value' => 'xts-icon xts-chevron-left',
                    'library' => 'solid',
                ],
            ]
        );

        $this->add_control(
            'slide_arrow_icon_right',
            [
                'label' => esc_html__('Right Arrow', 'qoxag'),
                'type' => \Elementor\Controls_Manager::ICONS,
                'condition' => [
                    'slide_arrows' => 'yes'
                ],
                'default' => [
                    'value' => 'xts-icon xts-chevron-right',
                    'library' => 'solid',
                ],
            ]
        );

        $this->add_control(
            'slide_dots',
            [
                'label' => esc_html__('Show Dots', 'qoxag'),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_off' => esc_html__('Hide', 'qoxag'),
                'label_on' => esc_html__('Show', 'qoxag'),
                'default' => (isset($default['slide_dots']) ? esc_attr($default['slide_dots']) : 'yes'),
                'return_value' => 'yes',
                'condition' => [
                    'layout_layout_style!' => ['featured-slider thumb-top'],
                ],
            ]
        );

        $this->add_control(
            'slider_column_gap',
            [
                'label' => esc_html__('Column Gap', 'qoxag'),
                'type' => \Elementor\Controls_Manager::SLIDER,
                'size_units' => ['px'],
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 100,
                        'step' => 1,
                    ]
                ],
                'default' => [
                    'unit' => 'px',
                    'size' => (isset($default['slider_column_gap']['default']) ? esc_attr($default['slider_column_gap']['default']) : 40)
                ],
                'tablet_default' => [
                    'unit' => '%',
                    'size' => (isset($default['slider_column_gap']['tablet_default']) ? esc_attr($default['slider_column_gap']['tablet_default']) : 30)
                ],
                'mobile_default' => [
                    'unit' => '%',
                    'size' => (isset($default['slider_column_gap']['mobile_default']) ? esc_attr($default['slider_column_gap']['mobile_default']) : 20)
                ],
            ]
        );

        $this->end_controls_section();
    }

    /*
     * Slider Style Control
     */
    protected function slider_style_controls($params = [])
    {
        $default = !empty($params) && !empty($params['defaults']) ? $params['defaults'] : [];
        $exclude = !empty($params) && !empty($params['exclude']) ? $params['exclude'] : [];

        $this->start_controls_section(
            'section_slider_style',
            [
                'label' => esc_html__('Main Slider Style', 'qoxag'),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE
            ]
        );

        $this->add_responsive_control(
            'bottom_spacing',
            [
                'label' => esc_html__('Bottom Spacing', 'qoxag'),
                'type' => \Elementor\Controls_Manager::SLIDER,
                'size_units' => ['px', '%'],
                'range' => [
                    'px' => [
                        'min' => -500,
                        'max' => 500,
                        'step' => 1,
                    ],
                    '%' => [
                        'min' => -100,
                        'max' => 100,
                    ],
                ],
                'default' => [
                    'unit' => (isset($default['bottom_spacing']['unit']) ? esc_attr($default['bottom_spacing']['unit']) : 'px'),
                    'size' => (isset($default['bottom_spacing']['size']) ? esc_attr($default['bottom_spacing']['size']) : 0),
                ],
                'selectors' => [
                    '{{WRAPPER}} .qoxag-main-slider-container' => 'margin-bottom: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'thumb_items_width',
            [
                'label' => esc_html__('Thumb Container Width', 'qoxag'),
                'type' => \Elementor\Controls_Manager::SLIDER,
                'size_units' => ['px', '%'],
                'range' => [
                    '%' => [
                        'min' => 0,
                        'max' => 100,
                    ],
                    'px' => [
                        'min' => -500,
                        'max' => 500,
                        'step' => 1,
                    ],
                ],
                'default' => [
                    'unit' => (isset($default['thumb_items_width']['unit']) ? esc_attr($default['thumb_items_width']['unit']) : '%'),
                    'size' => (isset($default['thumb_items_width']['size']) ? esc_attr($default['thumb_items_width']['size']) : 100),
                ],
                'selectors' => [
                    '{{WRAPPER}} .qoxag-main-slider .qoxag-thumb-slider-container' => 'max-width: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        //title
        $this->add_control(
            'title_heading',
            [
                'label' => esc_html__('Title', 'qoxag'),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );

        $this->add_control(
            'featured_title_color',
            [
                'label' => esc_html__('Title Color', 'qoxag'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'default' => '#fff',
                'selectors' => [
                    '{{WRAPPER}} .qoxag-main-slider-container .swiper-slide-active .qoxag-grid-single .post-heading a' => 'color: {{VALUE}};',
                    '{{WRAPPER}} .qoxag-main-slider-container .swiper-slide-active .qoxag-grid-single .post-heading' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'featured_post_title_crop',
            [
                'label' => esc_html__('Title Word Limit', 'qoxag'),
                'type' => \Elementor\Controls_Manager::SLIDER,
                'range' => [
                    'px' => [
                        'min' => 1,
                        'max' => 100,
                    ],
                ],
                'default' => [
                    'unit' => 'px',
                    'size' => 35,
                ],
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            [
                'name' => 'featured_title_typography',
                'label' => esc_html__('Title Typography', 'qoxag'),
                'selector' => '{{WRAPPER}} .qoxag-main-slider-container .swiper-slide-active .qoxag-grid-single .post-heading',
                'fields_options' => [
                    'typography' => [
                        'default' => 'custom',
                    ],
                    'font_weight' => [
                        'default' => '700',
                    ],
                    'font_size' => [
                        'default' => [
                            'size' => '23',
                            'unit' => 'px'
                        ],
                        'size_units' => ['px']
                    ],
                    'line_height' => [
                        'default' => [
                            'size' => '30',
                            'unit' => 'px'
                        ],
                        'size_units' => ['px']
                    ],
                ],
            ]
        );



        $this->add_control(
            'image_heading',
            [
                'label' => esc_html__('Thumbnail', 'qoxag'),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );

        $this->add_responsive_control(
            'main_slider_image_aspect_ratio',
            [
                'label' => esc_html__('Image Aspect Ratio', 'qoxag'),
                'type' => \Elementor\Controls_Manager::SLIDER,
                'size_units' => ['%'],
                'range' => [
                    '%' => [
                        'min' => 0.01,
                        'max' => 3.0,
                        'step' => 0.01,
                    ],
                ],
                'default' => [
                    'unit' => '%',
                    'size' => (isset($default['main_slider_image_aspect_ratio']['default']) ? esc_attr($default['main_slider_image_aspect_ratio']['default']) : 0.5)
                ],
                'tablet_default' => [
                    'unit' => '%',
                    'size' => (isset($default['main_slider_image_aspect_ratio']['tablet_default']) ? esc_attr($default['main_slider_image_aspect_ratio']['tablet_default']) : 0.3)
                ],
                'mobile_default' => [
                    'unit' => '%',
                    'size' => (isset($default['main_slider_image_aspect_ratio']['mobile_default']) ? esc_attr($default['main_slider_image_aspect_ratio']['mobile_default']) : 0.5)
                ],
                'selectors' => [
                    '{{WRAPPER}} .qoxag-main-slider-container .post-thumbnail' => 'padding-bottom: calc( {{size}} * 100% );',
                ],
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Image_Size::get_type(),
            [
                'name' => 'main_slider_img_size',
                'exclude' => ['custom'],
                'include' => [],
                'default' => 'large',
            ]
        );

        $this->add_control(
            'featured_meta_color',
            [
                'label' => esc_html__('Meta Color', 'qoxag'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'default' => '#fff',
                'selectors' => [
                    '{{WRAPPER}} .qoxag-main-slider-container .swiper-slide-active .qoxag-grid-single .post-meta span' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'featured_slider_padding',
            [
                'label' => esc_html__('Content Padding', 'qoxag'),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px'],
                'default' => [
                    'top' => '0',
                    'right' => '0',
                    'bottom' => '0',
                    'left' => '15',
                    'unit' => 'px',
                    'isLinked' => false,
                ],
                'selectors' => [
                    '{{WRAPPER}} .qoxag-main-slider-container .swiper-slide-active .qoxag-grid-single .post-content' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->end_controls_section();
    }
    /*
    *   Slider Navigation Style Controls
    */
    protected function slider_navigation_style_controls()
    {

        $this->start_controls_section(
            'section_slider_navigationn_style',
            [
                'label' => esc_html__('Slider Navigation', 'qoxag'),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE
            ]
        );

        $this->add_control(
            'arrow_heading',
            [
                'label' => esc_html__('Arrow Style', 'qoxag'),
                'type' => \Elementor\Controls_Manager::HEADING,
                'condition' => ['slide_arrows' => 'yes'],
            ]
        );

        $this->start_controls_tabs('slider_arrow_tabs');

        $this->start_controls_tab(
            'slider_arrow_style_normal',
            [
                'label' => esc_html__('Normal', 'qoxag'),
            ]
        );

        $this->add_control(
            'slide_arrow_color',
            [
                'label' => esc_html__('Color', 'qoxag'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'default' => '#FFFFFF',
                'selectors' => [
                    '{{WRAPPER}} .swiper-button-prev i' => 'color: {{VALUE}};',
                    '{{WRAPPER}} .swiper-button-next i' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'slide_arrow_bg_color',
            [
                'label' => esc_html__('background Color', 'qoxag'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'default' => '#4E65FF',
                'selectors' => [
                    '{{WRAPPER}}  .swiper-button-prev i' => 'background-color: {{VALUE}};',
                    '{{WRAPPER}}  .swiper-button-next i' => 'background-color: {{VALUE}};',
                ],
            ]
        );

        $this->end_controls_tab();

        $this->start_controls_tab(
            'slider_arrow_style_hover',
            [
                'label' => esc_html__('Hover', 'qoxag'),
            ]
        );

        $this->add_control(
            'slide_arrow_color_hover',
            [
                'label' => esc_html__('Color', 'qoxag'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .swiper-button-prev:hover i' => 'color: {{VALUE}};',
                    '{{WRAPPER}} .swiper-button-next:hover i' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'slide_arrow_bg_color_hover',
            [
                'label' => esc_html__('background Color', 'qoxag'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .swiper-button-prev:hover i' => 'background-color: {{VALUE}};',
                    '{{WRAPPER}} .swiper-button-next:hover i' => 'background-color: {{VALUE}};',
                ],
            ]
        );

        $this->end_controls_tab();

        $this->end_controls_tabs();

        $this->add_control(
            'slide_arrow_size',
            [
                'label' => esc_html__('Arrows Size', 'qoxag'),
                'type' => \Elementor\Controls_Manager::SLIDER,
                'condition' => ['slide_arrows' => 'yes'],
                'size_units' => ['px'],
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 1000,
                        'step' => 5,
                    ],
                ],
                'default' => [
                    'unit' => 'px',
                    'size' => 20,
                ],
                'selectors' => [
                    '{{WRAPPER}} .swiper-button-next i' => 'font-size: {{SIZE}}{{UNIT}};',
                    '{{WRAPPER}} .swiper-button-prev i' => 'font-size: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'arrow_position_vertical',
            [
                'label' => esc_html__('Arrow Vertical Position', 'qoxag'),
                'type' => \Elementor\Controls_Manager::SLIDER,
                'size_units' => ['px', '%'],
                'range' => [
                    'px' => [
                        'min' => -500,
                        'max' => 500,
                        'step' => 1,
                    ],
                    '%' => [
                        'min' => -100,
                        'max' => 100,
                        'step' => 1,
                    ],
                ],
                'default' => [
                    'unit' => '%',
                    'size' => 50,
                ],
                'selectors' => [
                    '{{WRAPPER}} .swiper-button-next' => 'top: {{SIZE}}{{UNIT}};',
                    '{{WRAPPER}} .swiper-button-prev' => 'top: {{SIZE}}{{UNIT}};',
                ],
                'separator' => 'before',
            ]
        );

        $this->add_responsive_control(
            'arrow_position_horizontal',
            [
                'label' => esc_html__('Arrow Horizontal Position', 'qoxag'),
                'type' => \Elementor\Controls_Manager::SLIDER,
                'size_units' => ['px', '%'],
                'separator' => 'after',
                'range' => [
                    'px' => [
                        'min' => -500,
                        'max' => 500,
                        'step' => 1,
                    ],
                    '%' => [
                        'min' => -100,
                        'max' => 100,
                        'step' => 1,
                    ],
                ],
                'default' => [
                    'unit' => 'px',
                    'size' => 20,
                ],
                'selectors' => [
                    '{{WRAPPER}} .swiper-button-next' => 'right: {{SIZE}}{{UNIT}};',
                    '{{WRAPPER}} .swiper-button-prev' => 'left: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'slide_arrow_padding',
            [
                'label' => esc_html__('Padding', 'qoxag'),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px'],
                'default' => [
                    'top' => '10',
                    'right' => '14',
                    'bottom' => '10',
                    'left' => '14',
                    'unit' => 'px',
                    'isLinked' => false,
                ],
                'selectors' => [
                    '{{WRAPPER}} .swiper-button-prev i' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    '{{WRAPPER}} .swiper-button-next i' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Border::get_type(),
            [
                'name' => 'slide_arrow_border',
                'label' => esc_html__('Border', 'qoxag'),
                'selector' => '{{WRAPPER}} .swiper-button-prev i, {{WRAPPER}} .swiper-button-next i',
            ]
        );

        $this->add_responsive_control(
            'slide_arrow_border_radius',
            [
                'label' => esc_html__('Border Radius', 'qoxag'),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%'],
                'default' => [
                    'top' => '50',
                    'right' => '50',
                    'bottom' => '50',
                    'left' => '50',
                    'unit' => '%',
                    'isLinked' => true,
                ],
                'selectors' => [
                    '{{WRAPPER}} .swiper-button-prev i' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    '{{WRAPPER}} .swiper-button-next i' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_control(
            'dots_heading',
            [
                'label' => esc_html__('Dots Style', 'qoxag'),
                'type' => \Elementor\Controls_Manager::HEADING,
                'condition' => ['slide_dots' => 'yes'],
                'separator' => 'before'
            ]
        );

        $this->add_control(
            'slide_dots_color',
            [
                'label' => esc_html__('Dots Color', 'qoxag'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'condition' => ['slide_dots' => 'yes'],
                'selectors' => [
                    '{{WRAPPER}} .swiper-pagination-bullet' => 'background: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'slide_dots_color_active',
            [
                'label' => esc_html__('Actove Dots Color', 'qoxag'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'condition' => ['slide_dots' => 'yes'],
                'selectors' => [
                    '{{WRAPPER}} .swiper-pagination-bullet.swiper-pagination-bullet-active' => 'background: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'slide_dots_size',
            [
                'label' => esc_html__('Dots Size', 'qoxag'),
                'type' => \Elementor\Controls_Manager::SLIDER,
                'condition' => ['slide_dots' => 'yes'],
                'size_units' => ['px'],
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 50,
                        'step' => 1,
                    ],
                ],
                'default' => [
                    'unit' => 'px',
                    'size' => 6,
                ],
                'selectors' => [
                    '{{WRAPPER}} .swiper-pagination-bullet' => 'width: {{SIZE}}{{UNIT}};height: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->add_control(
            'slide_dots_size_active',
            [
                'label' => esc_html__('Active Dots Size', 'qoxag'),
                'type' => \Elementor\Controls_Manager::SLIDER,
                'condition' => ['slide_dots' => 'yes'],
                'size_units' => ['px'],
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 50,
                        'step' => 1,
                    ],
                ],
                'default' => [
                    'unit' => 'px',
                    'size' => 14,
                ],
                'selectors' => [
                    '{{WRAPPER}} .swiper-pagination-bullet.swiper-pagination-bullet-active' => 'width: {{SIZE}}{{UNIT}};height: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->end_controls_section();
    }

    /*
     * Main Slider
     */

    protected function slider_fatured_controls()
    {
        $this->start_controls_section(
            'section_featured_style',
            [
                'label' => esc_html__('Featured', 'qoxag'),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'featured_post_title_typography',
                'label' => esc_html__('Title Typography', 'qoxag'),
                'selector' => '{{WRAPPER}} .first-block .qoxag-grid-single .post-heading a',
                'fields_options' => [
                    'typography' => [
                        'default' => 'custom',
                    ],
                    'font_weight' => [
                        'default' => '600',
                    ],
                    'font_size' => [
                        'default' => [
                            'size' => '18',
                            'unit' => 'px'
                        ],
                        'size_units' => ['px']
                    ],
                    'line_height' => [
                        'default' => [
                            'size' => '25',
                            'unit' => 'px'
                        ],
                        'size_units' => ['px']
                    ],
                ],
            ]
        );

        $this->add_responsive_control(
            'featured_thumbnail_image_aspect_ratio',
            [
                'label' => esc_html__('Image Aspect Ratio', 'qoxag'),
                'type' => \Elementor\Controls_Manager::SLIDER,
                'condition' => ['featured_show_thumbnail' => ['yes']],
                'size_units' => ['%'],
                'range' => [
                    '%' => [
                        'min' => 0.01,
                        'max' => 3.0,
                        'step' => 0.01,
                    ],
                ],
                'default' => [
                    'unit' => '%',
                    'size' => 0.5,
                ],
                'tablet_default' => [
                    'unit' => '%',
                    'size' => 0.3,
                ],
                'mobile_default' => [
                    'unit' => '%',
                    'size' => 0.5,
                ],
                'selectors' => [
                    '{{WRAPPER}} .first-block .qoxag-grid-single .post-thumbnail' => 'padding-bottom: calc( {{size}} * 100% );',
                ],
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Image_Size::get_type(),
            [
                'name' => 'featured_thumbnail_img_size',
                'condition' => ['featured_show_thumbnail' => ['yes']],
                'exclude' => ['custom'],
                'include' => [],
                'default' => 'large',
            ]
        );

        $this->add_responsive_control(
            'featured_content_padding',
            [
                'label' => esc_html__('Content Padding', 'qoxag'),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px'],
                'default' => [
                    'top' => '0',
                    'right' => '0',
                    'bottom' => '0',
                    'left' => '0',
                    'unit' => 'px',
                    'isLinked' => false,
                ],
                'selectors' => [
                    '{{WRAPPER}} .first-block .qoxag-grid-single .post-content' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->end_controls_section();
    }
}
